#ifndef iom_HPP
#define iom_HPP

#include "common.hpp"  
#include <fstream>
#include <vector>
#include <set>
using namespace std;

class iom:public ofstream
{
public:

   iom( ifstream& basket_file,  
			 const char* output_file_name );
   
   /// Reads in one transaction from the basketfile.
   int read_in_a_line( set<itemtype>& basket );

   /// Determines the frequent items, 
   /// fills in the new_code an new_code_inverse vectors
   countertype find_frequent_items( 
      const double min_supp, vector<countertype>& support_of_items );

   /// Creates an other basket that contains only the frequent items recoded.
   void basket_recode( const set<itemtype>& original_basket, 
		       vector<itemtype>& new_basket );

   /// Writes out an itemset to the output file.
   void write_out_basket( const set<itemtype>& itemset );

   /// Writes out an itemset and its counter to the output file.
   void write_out_basket_and_counter( const set<itemtype>& itemset, 
				      const countertype counter );

   ///
   void rewind(); 

   ~iom( );

private:
/// The file that contain the transactions (i.e baskets).
   ifstream& basket_file;
   
  vector<itemtype> new_code;
   vector<itemtype> new_code_inverse;
};


#endif
